<?php
/*--------------------------------------------------------------
   Renamed.php 2021-06-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Label;

class Renamed
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var Label
     */
    private $label;
    
    
    /**
     * Constructor.
     */
    private function __construct(Id $id, Label $label)
    {
        $this->id    = $id;
        $this->label = $label;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Id $id, Label $label): self
    {
        return new self($id, $label);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * Return label.
     */
    public function label(): Label
    {
        return $this->label;
    }
}